package gov.va.genisis2.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class User.
 * 
 * Description: In this User Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User in the database.
 * 
 */
@Entity
@Table(name = "Users", schema = "dbo")
@XmlRootElement(name = "response")
@JsonIgnoreProperties({ "userApproversForUserApproverId", "userRoleTypes", "userApproversForUserId", "inactiveDate",
		"activeDate", "userActive", "lastName2" })
public class Users implements java.io.Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 988724343861680365L;

	/** The user id. */
	private int userId;

	/** The first name. */
	private String firstName;
	
	/** The middle name. */
	private String middleName;
	
	/** The last name. */
	private String lastName;
	
	/** The last name 2. */
	private String lastName2;
	
	/** The create date. */
	private Date createDate;
	
	/** The email id. */
	private String emailId;
	
	/** The user active. */
	private byte userActive;
	
	/** The active date. */
	private Date activeDate;
	
	/** The inactive date. */
	private Date inactiveDate;
	
	/** The user approvers for user id. */
	private Set<UserApprover> userApproversForUserId = new HashSet<>(0);
	
	/** The user role types. */
	private Set<UserRoleType> userRoleTypes = new HashSet<>(0);
	
	/** The user approvers for user approver id. */
	private Set<UserApprover> userApproversForUserApproverId = new HashSet<>(0);

	/** The role. */
	private String role;
	
	/** The approver. */
	private String approver;

	/**
	 * Instantiates a new users.
	 */
	public Users() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new users.
	 *
	 * @param userId the user id
	 * @param firstName the first name
	 * @param lastName the last name
	 * @param createDate the create date
	 * @param emailId the email id
	 * @param userActive the user active
	 * @param activeDate the active date
	 */
	public Users(int userId, String firstName, String lastName, Date createDate, String emailId, byte userActive,
			Date activeDate) {
		this.userId = userId;
		this.firstName = firstName;
		this.lastName = lastName;
		this.createDate = createDate;
		this.emailId = emailId;
		this.userActive = userActive;
		this.activeDate = activeDate;
	}

	/**
	 * Instantiates a new users.
	 *
	 * @param userId the user id
	 * @param firstName the first name
	 * @param middleName the middle name
	 * @param lastName the last name
	 * @param lastName2 the last name 2
	 * @param createDate the create date
	 * @param emailId the email id
	 * @param userActive the user active
	 * @param activeDate the active date
	 * @param inactiveDate the inactive date
	 * @param userApproversForUserId the user approvers for user id
	 * @param userRoleTypes the user role types
	 * @param userApproversForUserApproverId the user approvers for user approver id
	 */
	public Users(int userId, String firstName, String middleName, String lastName, String lastName2, Date createDate,
			String emailId, byte userActive, Date activeDate, Date inactiveDate,
			Set<UserApprover> userApproversForUserId, Set<UserRoleType> userRoleTypes,
			Set<UserApprover> userApproversForUserApproverId) {
		this.userId = userId;
		this.firstName = firstName;
		this.middleName = middleName;
		this.lastName = lastName;
		this.lastName2 = lastName2;
		this.createDate = createDate;
		this.emailId = emailId;
		this.userActive = userActive;
		this.activeDate = activeDate;
		this.inactiveDate = inactiveDate;
		this.userApproversForUserId = userApproversForUserId;
		this.userRoleTypes = userRoleTypes;
		this.userApproversForUserApproverId = userApproversForUserApproverId;
	}

	/**
	 * Gets the user id.
	 *
	 * @return the user id
	 */
	@Id
	@Column(name = "User_id", unique = true, nullable = false, length = 50)
	public int getUserId() {
		return this.userId;
	}

	/**
	 * Sets the user id.
	 *
	 * @param userId the new user id
	 */
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * Gets the first name.
	 *
	 * @return the first name
	 */
	@Column(name = "First_Name", nullable = false, length = 50)
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * Sets the first name.
	 *
	 * @param firstName the new first name
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * Gets the middle name.
	 *
	 * @return the middle name
	 */
	@Column(name = "Middle_Name", length = 50)
	public String getMiddleName() {
		return this.middleName;
	}

	/**
	 * Sets the middle name.
	 *
	 * @param middleName the new middle name
	 */
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	/**
	 * Gets the last name.
	 *
	 * @return the last name
	 */
	@Column(name = "Last_Name", nullable = false, length = 50)
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * Sets the last name.
	 *
	 * @param lastName the new last name
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * Gets the last name 2.
	 *
	 * @return the last name 2
	 */
	@Column(name = "Last_Name2", length = 50)
	public String getLastName2() {
		return this.lastName2;
	}

	/**
	 * Sets the last name 2.
	 *
	 * @param lastName2 the new last name 2
	 */
	public void setLastName2(String lastName2) {
		this.lastName2 = lastName2;
	}

	/**
	 * Gets the creates the date.
	 *
	 * @return the creates the date
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Create_Date", nullable = false, length = 23)
	public Date getCreateDate() {
		return this.createDate;
	}

	/**
	 * Sets the creates the date.
	 *
	 * @param createDate the new creates the date
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * Gets the email id.
	 *
	 * @return the email id
	 */
	@Column(name = "Email_id", nullable = false, length = 320)
	public String getEmailId() {
		return this.emailId;
	}

	/**
	 * Sets the email id.
	 *
	 * @param emailId the new email id
	 */
	public void setEmailId(String emailId) {
		this.emailId = emailId;
	}

	/**
	 * Gets the user active.
	 *
	 * @return the user active
	 */
	@Column(name = "User_Active", nullable = false)
	public byte getUserActive() {
		return this.userActive;
	}

	/**
	 * Sets the user active.
	 *
	 * @param userActive the new user active
	 */
	public void setUserActive(byte userActive) {
		this.userActive = userActive;
	}

	/**
	 * Gets the active date.
	 *
	 * @return the active date
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Active_date", nullable = false, length = 23)
	public Date getActiveDate() {
		return this.activeDate;
	}

	/**
	 * Sets the active date.
	 *
	 * @param activeDate the new active date
	 */
	public void setActiveDate(Date activeDate) {
		this.activeDate = activeDate;
	}

	/**
	 * Gets the inactive date.
	 *
	 * @return the inactive date
	 */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Inactive_date", length = 23)
	public Date getInactiveDate() {
		return this.inactiveDate;
	}

	/**
	 * Sets the inactive date.
	 *
	 * @param inactiveDate the new inactive date
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}

	/**
	 * Gets the role.
	 *
	 * @return the role
	 */
	@Transient
	public String getRole() {
		return role;
	}

	/**
	 * Sets the role.
	 *
	 * @param role the new role
	 */
	public void setRole(String role) {
		this.role = role;
	}

	/**
	 * Gets the approver.
	 *
	 * @return the approver
	 */
	@Transient
	public String getApprover() {
		return approver;
	}

	/**
	 * Sets the approver.
	 *
	 * @param approver the new approver
	 */
	public void setApprover(String approver) {
		this.approver = approver;
	}

	/**
	 * Gets the user approvers for user id.
	 *
	 * @return the user approvers for user id
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "usersByUserId")
	public Set<UserApprover> getUserApproversForUserId() {
		return this.userApproversForUserId;
	}

	/**
	 * Sets the user approvers for user id.
	 *
	 * @param userApproversForUserId the new user approvers for user id
	 */
	public void setUserApproversForUserId(Set<UserApprover> userApproversForUserId) {
		this.userApproversForUserId = userApproversForUserId;
	}

	/**
	 * Gets the user role types.
	 *
	 * @return the user role types
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "users")
	public Set<UserRoleType> getUserRoleTypes() {
		return this.userRoleTypes;
	}

	/**
	 * Sets the user role types.
	 *
	 * @param userRoleTypes the new user role types
	 */
	public void setUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}

	/**
	 * Gets the user approvers for user approver id.
	 *
	 * @return the user approvers for user approver id
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "usersByUserApproverId")
	public Set<UserApprover> getUserApproversForUserApproverId() {
		return this.userApproversForUserApproverId;
	}

	/**
	 * Sets the user approvers for user approver id.
	 *
	 * @param userApproversForUserApproverId the new user approvers for user approver id
	 */
	public void setUserApproversForUserApproverId(Set<UserApprover> userApproversForUserApproverId) {
		this.userApproversForUserApproverId = userApproversForUserApproverId;
	}

}
